<?php
/**
*  Enqueue parent stylesheet
* @since Fansee Business Lite 1.0
*/
function fansee_business_lite_scripts(){
	$theme_version = wp_get_theme()->get( 'Version' );
	wp_enqueue_style( 'fansee-business-parent-style', get_template_directory_uri() . '/style.css', array(), $theme_version );
}
add_action( 'wp_enqueue_scripts', 'fansee_business_lite_scripts' );

/**
*  Add options for top header
* @since Fansee Business Lite 1.0
*/
function fansee_business_lite_customizer_register(){
	$panel = array(
		'id' => Fansee_Business_Customizer::get_id( 'fansee-business-lite' ),
		'args' => array(
			'title'    => esc_html__( 'Fansee Business Lite', 'fansee-business-lite' ),
			'priority' => 10,
		)
	);

	$customizer = new Fansee_Business_Customizer();
	$customizer->fields = array(
		array(
		    'id'     => 'top-header',
		    'title'  => esc_html__( 'Top Header', 'fansee-business-lite' ),
		    'fields' => array(
		    	array(
		    		'id'      	  => 'top-header-enable',
		    		'label'   	  => esc_html__( 'Enable' , 'fansee-business-lite' ),
		    		'default' 	  => true,
		    		'type'	  	  => 'toggle'
		    	),
		    	array(
		    		'id'      	  => 'top-header-phone',
		    		'label'   	  => esc_html__( 'Phone' , 'fansee-business-lite' ),
		    		'default' 	  => '+999987675776',
		    		'type'	  	  => 'text',
		    		'active_callback' => 'fansee_business_lite_top_header_a_callback'
		    	),
		    	array(
		    		'id'      	  => 'top-header-email',
		    		'label'   	  => esc_html__( 'Email' , 'fansee-business-lite' ),
		    		'default' 	  => 'fanseethemes@gmail.com',
		    		'type'	  	  => 'text',
		    		'active_callback' => 'fansee_business_lite_top_header_a_callback'
		    	),
		    	array(
		    		'id'      	  => 'top-header-address',
		    		'label'   	  => esc_html__( 'Address' , 'fansee-business-lite' ),
		    		'default' 	  => 'NYC, NC 1234',
		    		'type'	  	  => 'text',
		    		'active_callback' => 'fansee_business_lite_top_header_a_callback'
		    	),
		    	array(
		    		'id'      	  => 'top-header-business-time',
		    		'label'   	  => esc_html__( 'Business Time' , 'fansee-business-lite' ),
		    		'default' 	  => '9 AM - 6 PM',
		    		'type'	  	  => 'text',
		    		'active_callback' => 'fansee_business_lite_top_header_a_callback'
		    	),
		    )
		)
	);

	$customizer->add( $panel );
}
add_action( 'init', 'fansee_business_lite_customizer_register' );

/**
*  Active callback function for top header
* @since Fansee Business Lite 1.0
*/
function fansee_business_lite_top_header_a_callback(){
	return Fansee_Business_Customizer::get( 'top-header-enable' );
}

/**
*  Register menu for social profile
* @since Fansee Business Lite 1.0
*/
function fansee_business_lite_register_nav(){
	register_nav_menus(array(
		'social' => esc_html__( 'Social', 'fansee-business-lite' )
	));
}
add_action( 'after_setup_theme', 'fansee_business_lite_register_nav' );

/**
 * get sidebar position
 * @since Fansee Business Lite 1.0
 */
function fansee_business_lite_get_sidebar_position(){
	if( is_search() ){
		return false;
	}elseif( is_singular( 'post' ) || is_page() || is_home() ){

		if( is_home() && is_front_page() ){
			$pos = fansee_business_get( 'sidebar-position' );
			return $pos;
		}

		if( is_front_page() ){
			return false;
		}
		
		$id = fansee_business_get_page_id();
		$meta_id = 'fansee-business-sidebar-position';
		$pos = get_post_meta( $id, $meta_id, true );
		if( $pos == '' ){
			$pos = 'show';
		}
		return $pos;
	}else{
		$pos = fansee_business_get( 'sidebar-position' );
		return $pos;
	}
}

/**
 * Determines if the page needs sidebar
 * overriding parent function
 * @since Fansee Business 1.0
 */
function fansee_business_has_sidebar(){
	$pos = fansee_business_lite_get_sidebar_position();
	if( !$pos ){
		return false;
	}
	return $pos != 'hide';
}

/**
 * add class on body according to sidebar position
 * @since Fansee Business Lite 1.0
 */
function fansee_business_lite_body_class( $classes ){

	$pos = fansee_business_lite_get_sidebar_position();
	if( $pos ){
		if( $pos == 'show' ){
			$pos = 'right';
		}
		$classes[] = $pos . '-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'fansee_business_lite_body_class' );